TITLE   'Coaxial Cable'                                                       { exa091.pde }
SELECT     errlim=3e-4 ngrid=1     spectral_colors	{ Student Edition }
VARIABLES   U
DEFINITIONS							{ SI units }		
   r1=2e-3     r2=1e-2     eps0=8.854e-12     U1=1.0
   eps=2.3*eps0      						{ Permittivity }
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   Dex=eps*Ex     Dey=eps*Ey     D=eps*E     Dm=magnitude(D)	
EQUATIONS
   div( D)=0	         						{ No volume charge }
BOUNDARIES
region 'domain'
   start 'outer' (r2,0)  value(U)=0  arc(center=0,0) angle=360
   start 'inner' (r1,0)  value(U)=U1 arc(center=0,0) angle=360  {Cut-out }
PLOTS
   contour( U)     contour( Dex)     contour( Dey)
   vector( D) norm     contour( Dm)     surface(Dm)
   elevation( Dm) on 'inner'     elevation( Dm) on 'outer'
END


